﻿using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Audio Preset")]
    public class AudioPreset : ScriptableObject
    {
        [SerializeField] private AudioClip[] _clips;
        [SerializeField] private float _volumeMultiplier = 1.0f;
        [SerializeField] private bool _muteAmbience = false;

        public AudioClip[] Clips { get { return _clips; } }
        public float VolumeMultiplier { get { return _volumeMultiplier; } }
        public bool MuteAmbience { get { return _muteAmbience; } }
    }
}
