﻿using UnityEngine;
using UnityEngine.Pool;

public class AudioSourcePool : MonoBehaviour
{
    private static AudioSourcePool _instance;

    private const int POOL_SIZE = 20;

    private IObjectPool<AudioSource> _pool;

    private void Awake()
    {
        _pool = new ObjectPool<AudioSource>(CreatePooledItem, OnTakeFromPool, OnReturnedToPool, OnDestroyPoolObject, true, POOL_SIZE);
    }

    public static AudioSource Get()
    {
        if (_instance == null)
        {
            GameObject gameObject = new GameObject("AudioSourcePool");
            _instance = gameObject.AddComponent<AudioSourcePool>();
        }

        return _instance._pool.Get();
    }

    public static void Release(AudioSource renderer)
    {
        renderer.transform.rotation = Quaternion.identity;
        _instance._pool.Release(renderer);
    }

    private AudioSource CreatePooledItem()
    {
        GameObject gameObject = new GameObject();
        gameObject.transform.parent = transform;
        return gameObject.AddComponent<AudioSource>();
    }

    private void OnTakeFromPool(AudioSource renderer)
    {
        renderer.gameObject.SetActive(true);
    }

    private void OnReturnedToPool(AudioSource renderer)
    {
        renderer.gameObject.SetActive(false);
    }

    private void OnDestroyPoolObject(AudioSource renderer)
    {
        Destroy(renderer.gameObject);
    }
}