using UnityEditor;
using UnityEngine;

namespace PK
{
    [CustomEditor(typeof(HexHero)), CanEditMultipleObjects]
    public class HexHeroEditor : Editor
    {
        private SerializedProperty _uid;

        private void OnEnable()
        {
            _uid = serializedObject.FindProperty("_uid");
            HexUniqueScriptableObjectHelper.CheckUid(_uid);
        }

        public override Texture2D RenderStaticPreview(string assetPath, Object[] subAssets, int width, int height)
        {
            HexHero hero = target as HexHero;
            Texture2D previewTexture = new Texture2D(width, height);
            IconRenderer.Render(hero.AnySprite, previewTexture, Vector2.one * 0.75f);
            return previewTexture;
        }
    }
}
