﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    public static class HexUniqueScriptableObjectHelper
    {
        public static void CheckUid(SerializedProperty uidProperty)
        {
            ulong currentUid = uidProperty.ulongValue;
            ulong uid = currentUid;

            string[] guids = AssetDatabase.FindAssets("t:" + typeof(HexUniqueScriptableObject));
            HexUniqueScriptableObject[] uniqueObjects = new HexUniqueScriptableObject[guids.Length];
            for (int i = 0; i < guids.Length; i++)
            {
                string path = AssetDatabase.GUIDToAssetPath(guids[i]);
                uniqueObjects[i] = AssetDatabase.LoadAssetAtPath<HexUniqueScriptableObject>(path);
            }

            while (!HexHelper.IsUidUnique(uid, uniqueObjects))
            {
                uid = HexHelper.GenerateUID();
            }
            if (uid != currentUid)
            {
                uidProperty.ulongValue = uid;
                uidProperty.serializedObject.ApplyModifiedProperties();
            }
        }
    }
}
