using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;
using System.Linq;

namespace PK
{
    class NamedObjectsListWindow : EditorWindow
    {
        private Vector2 scrollPosition;

        public void OnEnable()
        {

        }

        public void OnDisable()
        {

        }

        [MenuItem("PK/All Named Objects")]
        public static void ShowWindow()
        {
            var window = EditorWindow.GetWindow(typeof(NamedObjectsListWindow));
            window.titleContent = new GUIContent("Named Object List");
        }

        public bool RequiresConstantRepaint() => true;

        void OnGUI()
        {
            IReadOnlyList<KeyValuePair<ulong, string>> namedEntities = MapDataHelper.GetEntitiesNames();
            if (null == namedEntities)
            {
                EditorGUILayout.LabelField("Wait for it!", EditorStyles.boldLabel);
                return;
            }

            scrollPosition = EditorGUILayout.BeginScrollView(scrollPosition);
            float availableWidth = position.width;
            float labelWidth = availableWidth * 0.45f;

            GUILayout.BeginHorizontal();
            EditorGUILayout.LabelField("Object name", EditorStyles.boldLabel, GUILayout.MaxWidth(labelWidth));
            EditorGUILayout.LabelField("Actions", EditorStyles.boldLabel, GUILayout.MaxWidth(labelWidth));
            GUILayout.EndHorizontal();

            foreach (KeyValuePair<ulong, string> pair in namedEntities)
            {
                if (pair.Key == 0)
                {
                    continue;
                }
                GUILayout.BeginHorizontal();
                EditorGUILayout.LabelField(pair.Value, GUILayout.MaxWidth(labelWidth));
                if (GUILayout.Button("Edit " + pair.Key.ToString(), GUILayout.MaxWidth(labelWidth)))
                {
                    HexMapEditorWindow.Instance.StartEditingEntity(pair.Key);
                }
                GUILayout.EndHorizontal();
            }

            EditorGUILayout.EndScrollView();
        }
    }

}
