﻿using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Localization;

namespace PK
{
    public enum CharacterEmotion
    {
        Default
    }

    [CreateAssetMenu(menuName = "Hex/Character")]
    public class HexCharacter : ScriptableObject
    {
        [System.Serializable]
        public class AnimationData
        {
            [SerializeField] private CharacterEmotion _emotion;
            [SerializeField] private Sprite[] _sprites;
            [SerializeField] private float _framesPerSecond = 5f;

            public CharacterEmotion Emotion { get { return _emotion; } }
            public Sprite[] Sprites { get { return _sprites; } }
            public float FramesPerSecond { get { return _framesPerSecond; } }
        }

        [SerializeField] private LocalizedString _name;
        [SerializeField] private AnimationData[] _animations;

        public LocalizedString Name { get { return _name; } }

        public AnimationData GetAnimation(CharacterEmotion emotion)
        {
            foreach (AnimationData data in _animations)
            {
                if (data.Emotion == emotion)
                {
                    return data;
                }
            }
            return null;
        }
    }
}
