﻿using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Map")]
    public class HexMap : ScriptableObject
    {
        [SerializeField] private HexMapModel _model = new();
        [SerializeField] private bool _isStrategic = true;

        public HexMapModel Model { get { return _model; } }
        public bool IsStrategic { get { return _isStrategic; } }
        public Vector2Int Size { get { return new Vector2Int(_model.Width, _model.Height); } }

        public void Initialize(HexMapModel model)
        {
            _model = model;
        }

        public static HexMap[] GetAll()
        {
            return Resources.LoadAll<HexMap>("Maps");
        }
    }
}
