﻿using UnityEngine;

namespace PK
{
    [System.Flags]
    public enum HexDirection
    {
        SouthWest = 1,
        SouthEast = 2,
        East = 4,
        NorthEast = 8,
        NorthWest = 16,
        West = 32
    }

    [CreateAssetMenu(menuName = "Hex/Mask")]
    public class HexMask : ScriptableObject
    {
        [SerializeField] private Sprite _northWest;
        [SerializeField] private Sprite _northEast;
        [SerializeField] private Sprite _east;
        [SerializeField] private Sprite _southEast;
        [SerializeField] private Sprite _southWest;
        [SerializeField] private Sprite _west;
        [SerializeField] private Sprite _ground;
        [SerializeField] private Sprite _bigGround;
        [SerializeField] private Sprite _selection;

        public Sprite GetSprite(HexDirection direction)
        {
            switch (direction)
            {
                case HexDirection.NorthWest:
                    return _northWest;
                case HexDirection.NorthEast:
                    return _northEast;
                case HexDirection.East:
                    return _east;
                case HexDirection.SouthEast:
                    return _southEast;
                case HexDirection.SouthWest:
                    return _southWest;
                case HexDirection.West:
                    return _west;
                default:
                    return null;
            }
        }

        public Sprite GetGroundSprite()
        {
            return _ground;
        }

        // Temporary solution for fog of war pixel alignment bug during zoom
        public Sprite GetBigGroundSprite()
        {
            return _bigGround;
        }

        public Sprite GetSelectionSprite()
        {
            return _selection;
        }
    }
}
