﻿using System.Linq;
using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Config/ShadowGroups")]
    public class HexShadowGroups : ScriptableObject
    {
        [System.Serializable]
        public class ShadowGroup
        {
            [SerializeField] private string _name;
            [SerializeField] private bool _castShadow = true;
            [SerializeField] private int _receiveShadowMask = 0;

            public string Name { get { return _name; } }
            public bool CastShadow { get { return _castShadow; } }
            public int ReceiveShadowMask { get { return _receiveShadowMask; } }
        }

        private static HexShadowGroups _instance;

        [SerializeField] private ShadowGroup[] _shadowGroups;

        public static HexShadowGroups Instance
        {
            get
            {
                if (_instance == null)
                {
                    HexShadowGroups[] groups = Resources.LoadAll<HexShadowGroups>("");
                    _instance = groups[0];
                }
                return _instance;
            }
        }

        public string[] ShadowGroupNames { get { return _shadowGroups.Select((s) => s.Name).ToArray(); } }

        public int GetCastShadowMask(int shadowGroup)
        {
            return _shadowGroups[shadowGroup].CastShadow ? (1 << shadowGroup) : 0;
        }

        public int GetReceiveShadowMask(int shadowGroup)
        {
            int mask = _shadowGroups[shadowGroup].ReceiveShadowMask;
            return mask >= 0 ? mask : int.MaxValue;
        }
    }
}
