﻿using System.Collections.Generic;
using UnityEngine;

namespace PK
{
    [System.Serializable]
    public abstract class AIController
    {
        [SerializeField] private Player _player;
        [SerializeField] private SerializableDictionary<ulong, AITask> _tasks = new();

        public Player Player { get { return _player; } }

        public AIController(Player player)
        {
            _player = player;
        }

        public abstract void PrepareTaskQueue();
        public abstract AITask GetNextTask();
    }
}
