﻿using System.Collections.Generic;

namespace PK
{
    public partial class BaseController<TCustomContext>
    {
        protected enum CommandResult
        {
            Complete,
            Continue
        }

        protected interface ICommand
        {
            CommandResult Execute(IContext context);
        }

        protected interface ICommandForSubCommands
        {
            void PushSubCommand(ICommand command);
        }

        protected abstract class Command : ICommand, ICommandForSubCommands
        {
            private enum ExecutionState
            {
                SelfExec,
                SubExec,
                AfterExec,
                Complete
            }

            List<ICommand> _subCommands = new List<ICommand>();
            int _subCommandIndex;
            ExecutionState _state = ExecutionState.SelfExec;

            protected Command()
            {
            }

            CommandResult ICommand.Execute(IContext context)
            {
                if (_state == ExecutionState.SelfExec)
                {
                    CommandResult result = ExecuteBeforeChilds(context);
                    if (result == CommandResult.Complete)
                    {
                        if (_subCommands.Count > 0)
                        {
                            _state = ExecutionState.SubExec;
                            _subCommandIndex = 0;
                        }
                        else
                        {
                            _state = ExecutionState.AfterExec;
                        }
                        return CommandResult.Continue;
                    }
                    return result;
                }
                else if (_state == ExecutionState.SubExec)
                {
                    CommandResult result = _subCommands[_subCommandIndex].Execute(context);
                    if (result == CommandResult.Complete)
                    {
                        _subCommandIndex++;
                        if (_subCommandIndex >= _subCommands.Count)
                        {
                            _state = ExecutionState.AfterExec;
                        }
                        return CommandResult.Continue;
                    }
                    return result;
                }
                else if (_state == ExecutionState.AfterExec)
                {
                    ExecuteAfterChilds(context);
                    _state = ExecutionState.Complete;
                    return CommandResult.Complete;
                }
                else
                {
                    return CommandResult.Complete;
                }
            }

            void ICommandForSubCommands.PushSubCommand(ICommand command)
            {
                PushSubCommand(command);
            }

            protected void PushSubCommand(ICommand command)
            { 
                _subCommands.Add(command);
            }

            protected virtual CommandResult ExecuteBeforeChilds(IContext context) { return CommandResult.Complete; }
            protected virtual void ExecuteAfterChilds(IContext context) { }
        }
    }
}
