﻿using System;
using UnityEngine;

namespace PK
{
    public abstract partial class BaseController<TCustomContext>
    {
        private Context _context;
        private Turn _currentTurn;

        protected IContext BaseContext
        {
            get { return _context; }
        }

        protected void InitContext(Savefile.MapData mapData, Savefile savefile, EventManager eventManager, ControllerLocker locker, TCustomContext customContext)
        {
            _context = new Context();
            _context.Init(mapData, savefile, eventManager, locker, customContext);
        }

        protected virtual void OnTurnStart()
        {
        }

        protected virtual void OnTurnEnd()
        {
        }

        protected bool CreateAndExecuteTurn(Action<ITurn> onInitTurn)
        {
            if (_currentTurn != null)
            {
                Debug.Log("Can't start new turn.");
                return false;
            }

            Turn turn = new Turn(_context);
            _currentTurn = turn;
            onInitTurn?.Invoke(turn);
            OnTurnStart();
            return true;
        }

        protected bool Execute()
        {
            if (_currentTurn == null)
            {
                return false;
            }

            if (!_currentTurn.Execute())
            {
                _currentTurn = null;
                OnTurnEnd();
                return false;
            }

            return true;
        }
    }
}
