﻿
namespace PK
{
    public partial class BaseController<TCustomContext>
    {
        protected interface IContext
        {
            Savefile.MapData MapData { get; }
            Savefile Savefile { get; }
            IEventManager EventManager { get; }
            IControllerLocker Locker { get; }
            TCustomContext CustomContext { get; }
        }

        private class Context : IContext
        {
            private Savefile.MapData _mapData;
            private Savefile _savefile;
            private EventManager _eventManager;
            private ControllerLocker _locker;
            private TCustomContext _customContext;

            Savefile.MapData IContext.MapData => _mapData;
            Savefile IContext.Savefile => _savefile;
            IEventManager IContext.EventManager => _eventManager;
            IControllerLocker IContext.Locker => _locker;
            TCustomContext IContext.CustomContext => _customContext;

            public void Init(Savefile.MapData mapData, Savefile savefile, EventManager eventManager, ControllerLocker locker, TCustomContext customContext)
            {
                _mapData = mapData;
                _savefile = savefile;
                _eventManager = eventManager;
                _locker = locker;
                _customContext = customContext;
            }
        }
    }
}
