﻿using UnityEngine;

namespace PK.Strategic
{
    public partial class GameController
    {
        private class InteractProximityTriggersCommand : Command
        {
            private ulong _heroId;

            public InteractProximityTriggersCommand(ulong heroId)
            {
                _heroId = heroId;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                HexHeroModel hero = context.MapData.Map.GetHero(_heroId);
                foreach (HexProximityTriggerModel trigger in context.MapData.Map.GetEnumerable<HexProximityTriggerModel>())
                {
                    if (HexHelper.AxialDistance(hero.Position, trigger.Position) < trigger.Range)
                    {
                        if (trigger.Interaction is ActionInteraction actionInteraction)
                        {
                            ActionGraph graph = actionInteraction.Graph;
                            if (graph != null)
                            {
                                PushSubCommand(new ExecuteActionGraphCommand(graph, hero.Player, trigger, hero));
                            }
                        }
                        context.EventManager.Get<StrategicEvents>().CallOnHeroInteract(hero.Id, trigger.Id);
                    }
                }

                return CommandResult.Complete;
            }
        }
    }
}
