﻿
namespace PK.Strategic
{
    public partial class GameController
    {
        private class TrySwitchDayCommand : Command
        {
            public TrySwitchDayCommand()
            {
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                if (context.CustomContext.NextPlayer != Player.Red)
                {
                    return CommandResult.Complete;
                }
                // End previous day
                context.EventManager.Get<StrategicEvents>().CallOnEndDay(context.CustomContext.Day);
                PushSubCommand(new StartDaySubCommand());
                return CommandResult.Complete;
            }
        }
    }
}
