﻿
namespace PK.Strategic
{
    public partial class GameController
    {
        private class TryToEndTurnCommand : Command
        {
            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                foreach (HexHeroModel hero in context.MapData.Map.GetEnumerable<HexHeroModel>())
                {
                    if (hero.Player == context.CustomContext.Player && PathfindingHelper.CanMove(hero.Position, hero.StepsLeft, context.MapData.MovementCostMask, context.MapData.Map.Size))
                    {
                        return CommandResult.Complete;
                    }
                }
                PushSubCommand(new TrySwitchDayCommand());
                PushSubCommand(new SwitchTurnCommand());
                return CommandResult.Complete;
            }
        }
    }
}
