﻿
namespace PK.Strategic
{
    public partial class GameController
    {
        private class WalkHeroEndSubCommand : Command
        {
            private ulong _id;

            public WalkHeroEndSubCommand(ulong id)
            {
                _id = id;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                HexHeroModel hero = context.MapData.Map.GetHero(_id);
                context.EventManager.Get<StrategicEvents>().CallOnHeroEndWalk(_id, hero.Player);
                context.MapData.RefreshObstacleMask();
                context.EventManager.Get<MapDataEvents>().CallOnRefreshObstacleMask();
                return CommandResult.Complete;
            }
        }
    }
}
