﻿using System.Collections.Generic;
using UnityEngine;

namespace PK.Strategic
{
    public class CreatureSquadBar : MonoBehaviour, IEventReceiver
    {
        [SerializeField] private StrategicMapView _view;
        [SerializeField] private CreatureSquadBarIcon _iconPrefab;

        private List<CreatureSquadBarIcon> _icons = new();
        private List<ICreatureSquadModelForView> _squads = new();
        private List<ICreatureSquadModelForView> _temporarySquads = new();

        void IEventReceiver.AddEvents()
        {
            IStrategicEvents events = StrategicGameMediator.Instance.EventManager.Get<IStrategicEvents>();
            events.OnStartTurn += OnStartTurn;
            events.OnHeroModifyCreatureSquads += OnHeroModifyCreatureSquads;

            _view.OnUpdateSelectedHero += OnUpdateSelectedHero;
        }

        void IEventReceiver.RemoveEvents()
        {
            IStrategicEvents events = StrategicGameMediator.Instance.EventManager.Get<IStrategicEvents>();
            events.OnStartTurn -= OnStartTurn;
            events.OnHeroModifyCreatureSquads -= OnHeroModifyCreatureSquads;

            _view.OnUpdateSelectedHero -= OnUpdateSelectedHero;
        }

        private void OnStartTurn(Player player)
        {
            Refresh();
        }

        private void OnHeroModifyCreatureSquads(ulong id)
        {
            if (id == _view.SelectedHero.Id)
            {
                Refresh();
            }
        }

        private void OnUpdateSelectedHero(IHeroModelForView hero)
        {
            Refresh();
        }

        private void Refresh()
        {
            _squads.Clear();
            StrategicGameMediator.Instance.GetAllSquads(_view.SelectedHero.Id, _squads);
            for (int i = 0; i < _squads.Count; i++)
            {
                ICreatureSquadModelForView squad = _squads[i];
                CreatureSquadBarIcon icon;
                if (i < _icons.Count)
                {
                    icon = _icons[i];
                }
                else
                {
                    icon = Instantiate(_iconPrefab, transform);
                    _icons.Add(icon);
                }
                icon.SetActive(true);
                _temporarySquads.Clear();
                _temporarySquads.Add(squad);
                icon.Refresh(_temporarySquads, true);
            }
            for (int i = _squads.Count; i < _icons.Count; i++)
            {
                _icons[i].SetActive(false);
            }
        }
    }
}
