﻿using UnityEngine;
using UnityEngine.UI;

namespace PK.Strategic
{
    public class EndTurnButton : MonoBehaviour
    {
        [SerializeField] private Button _button;

        private bool _isActive = false;

        private void Start()
        {
            OnStartTurn(StrategicGameMediator.Instance.CurrentPlayer);

            IStrategicEvents events = StrategicGameMediator.Instance.EventManager.Get<IStrategicEvents>();
            events.OnStartTurn += OnStartTurn;
            events.OnEndTurn += OnEndTurn;
        }

        private void Update()
        {
            _button.interactable = !InputLock.IsLock && _isActive;
        }

        private void OnDestroy()
        {
            IStrategicEvents events = StrategicGameMediator.Instance.EventManager.Get<IStrategicEvents>();
            events.OnStartTurn -= OnStartTurn;
            events.OnEndTurn -= OnEndTurn;
        }

        public void OnClick()
        {
            if (!InputLock.IsLock)
            {
                StrategicGameMediator.Instance.EndPlayerTurn();
            }
        }

        private void OnStartTurn(Player player)
        {
            _isActive = (player == StrategicGameMediator.Instance.SelfPlayer);
        }

        private void OnEndTurn(Player player)
        {
            _isActive = false;
        }
    }
}
