﻿
using UnityEngine;

namespace PK.Strategic
{
    public partial class StrategicMapView
    {
        [Space]
        [SerializeField] private Canvas _canvas;

        private void AddInteractionEvents()
        {
            IStrategicEvents events = StrategicGameMediator.Instance.EventManager.Get<IStrategicEvents>();
            events.OnEndDay += OnEndDay;

            IInteractionEvents interactionEvents = StrategicGameMediator.Instance.EventManager.Get<IInteractionEvents>();
            interactionEvents.OnMessage += OnMessage;
            interactionEvents.OnDialog += OnDialog;
        }

        private void RemoveInteractionEvents()
        {
            IStrategicEvents events = StrategicGameMediator.Instance.EventManager.Get<IStrategicEvents>();
            events.OnEndDay -= OnEndDay;

            IInteractionEvents interactionEvents = StrategicGameMediator.Instance.EventManager.Get<IInteractionEvents>();
            interactionEvents.OnMessage -= OnMessage;
            interactionEvents.OnDialog -= OnDialog;
        }

        private void OnEndDay(int day)
        {
            day += 1;
            if (day > 1)
            {
                DayEndWindow.Create(GameClient.Instance.Canvas.transform, day, null);
            }
        }

        private void OnMessage(IDialogMessageForView messageForView, Player player)
        {
            if (player != StrategicGameMediator.Instance.SelfPlayer)
            {
                return;
            }
            
            DialogWindow.Create(GameClient.Instance.Canvas.transform, messageForView, null, (int index) =>
            {
                messageForView.Skip();
            });
        }

        private void OnDialog(IDialogChoicesForView dialogChoicesForView, Player player)
        {
            if (player != StrategicGameMediator.Instance.SelfPlayer)
            {
                return;
            }

            DialogWindow.Create(GameClient.Instance.Canvas.transform, dialogChoicesForView, dialogChoicesForView, (int index) =>
            {
                dialogChoicesForView.SelectChoice(index);
            });
        }
    }
}
