using DG.Tweening;
using System;
using TMPro;
using UnityEngine;
using UnityEngine.Localization.Components;
using UnityEngine.Localization.SmartFormat.PersistentVariables;

namespace PK.Strategic
{
    public class DayEndWindow : MonoBehaviour
    {
		[SerializeField] private CanvasGroup _canvasGroup;
		[SerializeField] private TMP_Text _dayText;
		[SerializeField] private LocalizeStringEvent _dayLabel;

		private Action _callback;

		public static void Create(Transform parent, int day, Action callback)
		{
			GameObject prefab = Resources.Load("Windows/DayEndWindow") as GameObject;
			GameObject gameObject = Instantiate(prefab, parent.transform);
			DayEndWindow window = gameObject.GetComponent<DayEndWindow>();
			window.Initialize(day, callback);
		}

		private void Initialize(int day, Action callback)
        {
			_callback = callback;
            IntVariable variable = _dayLabel.StringReference["day"] as IntVariable;
			variable.Value = day;

			_canvasGroup.alpha = 0f;
			DOTween.Sequence().Append(_canvasGroup.DOFade(1f, 1.0f)).AppendInterval(2.5f).Append(_canvasGroup.DOFade(0f, 0.5f)).OnComplete(() =>
			{
				Destroy(gameObject);
				_callback?.Invoke();
			});
		}
	}
}