﻿using System;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.Localization;
using UnityEngine.Localization.Components;
using UnityEngine.UI;

namespace PK
{
    public class DialogWindowChoice : MonoBehaviour
    {
        [SerializeField] private Button _button;
        [SerializeField] private LocalizeStringEvent _choiceLabel;

        private int _index;
        private BoxCollider2D _buttonCollider;
        private Action<int> _callback;

        public void Initialize(int index, LocalizedString line, Action<int> callback, bool wasUsed = false, bool useColliderForHover = false)
        {
            _index = index;
            _callback = callback;
            _choiceLabel.StringReference = line;
            _choiceLabel.RefreshString();
            if (wasUsed)
            {
                ColorBlock block = _button.colors;
                block.normalColor = MultiplyRGB(block.normalColor, 0.5f);
                block.pressedColor = MultiplyRGB(block.pressedColor, 0.5f);
                block.selectedColor = MultiplyRGB(block.selectedColor, 0.5f);
                block.highlightedColor = MultiplyRGB(block.highlightedColor, 0.5f);
                block.disabledColor = MultiplyRGB(block.disabledColor, 0.5f);
                _button.colors = block;
            }

            // Detect hover over dialogue choice even when it's covered by invisible message skip button
            if (useColliderForHover)
            {
                _buttonCollider = gameObject.AddComponent<BoxCollider2D>();
                _buttonCollider.size = GetComponent<RectTransform>().sizeDelta;
            }
        }

        public void OnChoiceClick()
        {
            _callback?.Invoke(_index);
        }

        public void OnMouseEnter()
        {
            PointerEventData pointer = new PointerEventData(EventSystem.current);
            ExecuteEvents.Execute(_button.gameObject, pointer, ExecuteEvents.pointerEnterHandler);
        }

        public void OnMouseExit()
        {
            PointerEventData pointer = new PointerEventData(EventSystem.current);
            ExecuteEvents.Execute(_button.gameObject, pointer, ExecuteEvents.pointerExitHandler);
        }

        private Color MultiplyRGB(Color color, float value)
        {
            color.r *= value;
            color.g *= value;
            color.b *= value;
            return color;
        }
    }
}
