﻿using DG.Tweening;
using System.Collections;
using UnityEngine;

namespace PK.Tactical
{
    public class TacticalAIWrapper : MonoBehaviour
    {
        private TacticalAIController _controller;

        public void Initialize(Savefile.MapData mapData, Player player)
        {
            _controller = new TacticalAIController(mapData, player);
        }

        private void Start()
        {
            ITacticalEvents events = TacticalGameMediator.Instance.EventManager.Get<ITacticalEvents>();
            events.OnStartTurn += OnStartTurn;
        }

        private void OnDestroy()
        {
            ITacticalEvents events = TacticalGameMediator.Instance.EventManager.Get<ITacticalEvents>();
            events.OnStartTurn -= OnStartTurn;
        }

        private void OnStartTurn(Player player)
        {
            if (player == _controller.Player)
            {
                StartCoroutine(ExecuteCoroutine());
            }
        }

        private IEnumerator ExecuteCoroutine()
        {
            yield return null;

            _controller.PrepareTaskQueue();
            AITask task = null;
            while ((task = _controller.GetNextTask()) != null)
            {
                bool canContinue = false;
                TacticalGameMediator.Instance.ExecuteAITask(task, () =>
                {
                    canContinue = true;
                });
                while (!canContinue)
                {
                    yield return null;
                }
            }
            TacticalGameMediator.Instance.EndTurn(_controller.Player);
        }
    }
}
