﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;

namespace PK.Tactical
{
    public partial class GameController
    {
        private class MoveSquadsCommand : Command
        {
            private Dictionary<ulong, Vector2Int> _targets;

            public MoveSquadsCommand(Dictionary<ulong, Vector2Int> targets)
            {
                _targets = targets;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                List<(HexCreatureSquadModel squad, List<(Vector2Int, int)> path)> pathes = new();
                foreach (KeyValuePair<ulong, Vector2Int> pair in _targets)
                {
                    // TODO validation
                    if (context.MapData.Map.GetEntity(pair.Key) is HexCreatureSquadModel squad && squad.Player == context.CustomContext.Player)
                    {
                        List<(Vector2Int, int)> path = PathfindingHelper.FindPath(squad.Position, pair.Value, context.MapData.ObstacleMask, context.MapData.MovementCostMask, context.MapData.Map.InteractionMask, context.MapData.Map.Size, _targets.Keys.Select((t) => (context.MapData.Map.GetEntity(t) as HexCreatureSquadModel).Position).ToList());
                        if (path == null)
                        {
                            Debug.LogError("No path");
                            return CommandResult.Complete;
                        }
                        else
                        {
                            pathes.Add((squad, path));
                            squad.StepsMoved += path.Count;
                        }
                    }
                }

                if (pathes.Count == 0)
                {
                    Debug.LogError("No path");
                    return CommandResult.Complete;
                }

                int maxPathLength = 0;
                foreach ((HexCreatureSquadModel squad, List<(Vector2Int, int)> path) in pathes)
                {
                    if (path == null)
                    {
                        return CommandResult.Complete;
                    }
                    maxPathLength = Mathf.Max(maxPathLength, path.Count);
                }

                HexCreature creature = HexDatabase.Instance.GetCreature(pathes[0].squad.Uid);
                for (int i = 1; i < maxPathLength; i++)
                {
                    List<(HexCreatureSquadModel squad, Vector2Int start, Vector2Int end)> data = new();
                    foreach ((HexCreatureSquadModel squad, List<(Vector2Int, int)> path) in pathes)
                    {
                        if (i < path.Count)
                        {
                            data.Add((squad, path[i - 1].Item1, path[i].Item1));
                        }
                    }
                    PushSubCommand(new MoveSquadsSubCommand(data));
                    PushSubCommand(new RevealFogOfWarCommand(data[0].end, creature.VisionRange, (context.MapData.Map.GetEntity(data[0].squad.Id) as HexCreatureSquadModel).Player));
                }

                List<HexCreatureSquadModel> allSquads = new();
                SquadHelper.GetAllSquads(_targets.Keys.First(), context.MapData.Map, allSquads);
                foreach (HexCreatureSquadModel squad in allSquads)
                {
                    squad.HasAction = false;
                    if (squad.ParentSquadId == 0)
                    {
                        context.EventManager.Get<TacticalEvents>().CallOnCreatureSquadUpdate(squad.Id, false);
                    }
                }

                return CommandResult.Complete;
            }

            protected override void ExecuteAfterChilds(IContext context)
            {
                context.MapData.RefreshObstacleMask();
                context.EventManager.Get<MapDataEvents>().CallOnRefreshObstacleMask();
            }
        }
    }
}
