﻿
namespace PK.Tactical
{
    public partial class GameController
    {
        private class TryToEndBattleCommand : Command
        {
            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                Player player = Player.Unknown;
                foreach (HexCreatureSquadModel squad in context.MapData.Map.GetEnumerable<HexCreatureSquadModel>())
                {
                    if (player == Player.Unknown)
                    {
                        player = squad.Player;
                    }
                    else if (player != squad.Player)
                    {
                        return CommandResult.Complete;
                    }
                }
                context.CustomContext.BattleInProgress = false;
                context.EventManager.Get<TacticalEvents>().CallOnEndBattle(player);
                return CommandResult.Complete;
            }
        }
    }
}
