﻿
namespace PK.Tactical
{
    public partial class GameController
    {
        public interface IGameContext
        {
            Player Player { get; set; }
            int PlayerCount { get; }
            Player NextPlayer { get; }
            bool BattleInProgress { get; set; }
        }

        public class GameContext : IGameContext
        {
            private Player _player = Player.Unknown;
            private int _playerCount = 2;
            private bool _battleInProgress = true;

            Player IGameContext.Player { get { return _player; } set { _player = value; } }
            int IGameContext.PlayerCount { get { return _playerCount; } }
            Player IGameContext.NextPlayer { get { return (Player)((int)(_player + 1) % _playerCount); } }
            bool IGameContext.BattleInProgress { get { return _battleInProgress; } set { _battleInProgress = value; } }

            public void Init()
            {
                _player = Player.Unknown;
                _battleInProgress = true;
            }
        }
    }
}
