﻿using System.Collections.Generic;
using UnityEngine;

namespace PK.Tactical
{
    public delegate void OnStartGameEvent(Vector2Int spawnAreaPosition);

    public delegate void OnStartTurnEvent(Player player);
    public delegate void OnEndTurnEvent(Player player);

    public delegate void OnUpdateFogOfWarEvent(bool[] mask, Vector2Int size);
    
    public delegate void OnCreatureSquadsCreateEvent(List<ICreatureSquadModelForView> squads);
    public delegate void OnCreatureSquadsMoveEvent(List<(ICreatureSquadModelForView squad, Vector2Int start, Vector2Int end)> data);
    public delegate void OnCreatureSquadsRegroupEvent(List<(ulong, ulong, int, int)> data);
    public delegate void OnCreatureSquadsStartAttackEvent(List<ulong> targetIds);
    public delegate void OnCreatureSquadsAttackMeleeEvent(List<ulong> ids, List<ulong> targetIds);
    public delegate void OnCreatureSquadsAttackRangedEvent(List<ulong> ids, List<Vector2Int> targets);
    public delegate void OnCreatureSquadsHitEvent(List<ICreatureSquadModelForView> targets, List<ICreatureSquadModelForView> allTargets);
    public delegate void OnCreatureSquadsSurrenderEvent(List<(ICreatureSquadModelForView, Vector2Int)> data);

    public delegate void OnCreatureSquadUpdateEvent(ulong id, bool hasAction);

    public delegate void OnEndBattleEvent(Player player);

    public interface ITacticalEvents
    {
        public event OnStartGameEvent OnStartGame;

        public event OnStartTurnEvent OnStartTurn;
        public event OnEndTurnEvent OnEndTurn;

        public event OnUpdateFogOfWarEvent OnUpdateFogOfWar;

        public event OnCreatureSquadsCreateEvent OnCreatureSquadsCreate;
        public event OnCreatureSquadsMoveEvent OnCreatureSquadsMove;
        public event OnCreatureSquadsRegroupEvent OnCreatureSquadsRegroup;
        public event OnCreatureSquadsStartAttackEvent OnCreatureSquadsStartAttack;
        public event OnCreatureSquadsAttackMeleeEvent OnCreatureSquadsAttackMelee;
        public event OnCreatureSquadsAttackRangedEvent OnCreatureSquadsAttackRanged;
        public event OnCreatureSquadsSurrenderEvent OnCreatureSquadsSurrender;
        public event OnCreatureSquadsHitEvent OnCreatureSquadsHit;

        public event OnCreatureSquadUpdateEvent OnCreatureSquadUpdate;

        public event OnEndBattleEvent OnEndBattle;
    }

    public class TacticalEvents : ITacticalEvents
    {
        public event OnStartGameEvent OnStartGame;

        public event OnStartTurnEvent OnStartTurn;
        public event OnEndTurnEvent OnEndTurn;

        public event OnUpdateFogOfWarEvent OnUpdateFogOfWar;

        public event OnCreatureSquadsCreateEvent OnCreatureSquadsCreate;
        public event OnCreatureSquadsMoveEvent OnCreatureSquadsMove;
        public event OnCreatureSquadsRegroupEvent OnCreatureSquadsRegroup;
        public event OnCreatureSquadsStartAttackEvent OnCreatureSquadsStartAttack;
        public event OnCreatureSquadsAttackMeleeEvent OnCreatureSquadsAttackMelee;
        public event OnCreatureSquadsAttackRangedEvent OnCreatureSquadsAttackRanged;
        public event OnCreatureSquadsSurrenderEvent OnCreatureSquadsSurrender;
        public event OnCreatureSquadsHitEvent OnCreatureSquadsHit;

        public event OnCreatureSquadUpdateEvent OnCreatureSquadUpdate;

        public event OnEndBattleEvent OnEndBattle;

        public void CallOnStartGame(Vector2Int spawnAreaPosition)
        {
            OnStartGame?.Invoke(spawnAreaPosition);
        }

        public void CallOnStartTurn(Player player)
        {
            OnStartTurn?.Invoke(player);
        }

        public void CallOnEndTurn(Player player)
        {
            OnEndTurn?.Invoke(player);
        }

        public void CallOnUpdateFogOfWar(bool[] mask, Vector2Int size)
        {
            OnUpdateFogOfWar?.Invoke(mask, size);
        }

        public void CallOnCreatureSquadsCreate(List<ICreatureSquadModelForView> squads)
        {
            OnCreatureSquadsCreate?.Invoke(squads);
        }

        public void CallOnCreatureSquadsMove(List<(ICreatureSquadModelForView squad, Vector2Int start, Vector2Int end)> data)
        {
            OnCreatureSquadsMove?.Invoke(data);
        }

        public void CallOnCreatureSquadsRegroup(List<(ulong, ulong, int, int)> data)
        {
            OnCreatureSquadsRegroup?.Invoke(data);
        }

        public void CallOnCreatureSquadsStartAttack(List<ulong> targetIds)
        {
            OnCreatureSquadsStartAttack?.Invoke(targetIds);
        }

        public void CallOnCreatureSquadsAttackMelee(List<ulong> ids, List<ulong> targetIds)
        {
            OnCreatureSquadsAttackMelee?.Invoke(ids, targetIds);
        }

        public void CallOnCreatureSquadsAttackRanged(List<ulong> ids, List<Vector2Int> targets)
        {
            OnCreatureSquadsAttackRanged?.Invoke(ids, targets);
        }

        public void CallOnCreatureSquadsSurrender(List<(ICreatureSquadModelForView, Vector2Int)> data)
        {
            OnCreatureSquadsSurrender?.Invoke(data);
        }
        
        public void CallOnCreatureSquadsHit(List<ICreatureSquadModelForView> targets, List<ICreatureSquadModelForView> allTargets)
        {
            OnCreatureSquadsHit?.Invoke(targets, allTargets);
        }

        public void CallOnCreatureSquadUpdate(ulong id, bool hasAction)
        {
            OnCreatureSquadUpdate?.Invoke(id, hasAction);
        }

        public void CallOnEndBattle(Player player)
        {
            OnEndBattle?.Invoke(player);
        }
    }
}
