using DG.Tweening;
using System;
using UnityEngine;

namespace PK.Tactical
{
	public interface IBattleMessageWindow
    {
		void Skip();
    }

	public class BattleMessageWindow : MonoBehaviour, IBattleMessageWindow
	{
		public enum Message
        {
			PlayerTurn,
			EnemyTurn,
			Victory,
			Defeat
        }

		[SerializeField] private CanvasGroup _canvasGroup;
		[SerializeField] private GameObject[] _panels;

		private Action _callback;
		private Sequence _sequence;

		public static IBattleMessageWindow Create(Transform parent, Message message, float showTimeScale = 1.0f, Action callback = null)
		{
			GameObject prefab = Resources.Load("Windows/BattleMessageWindow") as GameObject;
			GameObject gameObject = Instantiate(prefab, parent.transform);
			BattleMessageWindow window = gameObject.GetComponent<BattleMessageWindow>();
			window.Initialize(message, showTimeScale, callback);
			return window;
		}

		private void Initialize(Message message, float showTimeScale, Action callback)
        {
			_callback = callback;
			for (int i = 0; i < _panels.Length; i++)
            {
				_panels[i].SetActive(message == (Message)i);
            }
			_canvasGroup.alpha = 0f;
			_sequence = DOTween.Sequence().Append(_canvasGroup.DOFade(1f, 1.0f * showTimeScale)).AppendInterval(2.5f * showTimeScale).Append(_canvasGroup.DOFade(0f, 0.5f * showTimeScale)).OnComplete(() =>
			{
				Destroy(gameObject);
				_callback?.Invoke();
			});
		}

		void IBattleMessageWindow.Skip()
		{
			if (this != null && gameObject != null && _sequence != null)
			{
				DOTween.Kill(_sequence);
				_sequence = null;
				_canvasGroup.DOFade(0f, 0.2f * _canvasGroup.alpha);
			}
		}
	}
}