﻿using UnityEngine;

namespace PK
{
    public class ActionAddCreatureSquadsNode : ActionDefaultNode, IFlowNode
    {
        [SerializeField] private HexHeroModel.CreatureData[] _creatures;

        public void Execute(IActionContext context)
        {
            if (context.Interactor is HexHeroModel hero)
            {
                foreach (HexHeroModel.CreatureData creature in _creatures)
                {
                    context.Savefile.AddHeroSquads(hero, creature.Creature, creature.Count);
                }
                context.EventManager.Get<Strategic.StrategicEvents>().CallOnHeroModifyCreatureSquads(hero.Id);
                context.Graph.MoveToNextNode(_outPortGuid);
            }
        }
    }
}
