﻿using UnityEngine;

namespace PK
{
    public class ActionBranchNode : BaseNode, IFlowNode
    {
        [SerializeField] private string _inPortGuid;
        [SerializeField] private string _conditionPortGuid;
        [SerializeField] private string _outPortAGuid;
        [SerializeField] private string _outPortBGuid;

        public string InPortGuid { get { return _inPortGuid; } set { _inPortGuid = value; } }
        public string ConditionPortGuid { get { return _conditionPortGuid; } set { _conditionPortGuid = value; } }
        public string OutPortAGuid { get { return _outPortAGuid; } set { _outPortAGuid = value; } }
        public string OutPortBGuid { get { return _outPortBGuid; } set { _outPortBGuid = value; } }

        public void Execute(IActionContext context)
        {
            if (!context.Graph.IsConnected(_conditionPortGuid))
            {
                Debug.LogError("Branch has no condition.");
            }
            else if ((context.Graph.GetConnectedNode(_conditionPortGuid) is IConditionNode conditionNode && conditionNode.Evaluate(context)))
            {
                context.Graph.MoveToNextNode(_outPortAGuid);
                return;
            }
            context.Graph.MoveToNextNode(_outPortBGuid);
        }
    }
}
