﻿using UnityEngine;

namespace PK
{
    public class ActionCheckCharacterNode : ActionDefaultNode, IConditionNode
    {
        [SerializeField] private HexCharacter _value;

        bool IConditionNode.Evaluate(IActionContext context)
        {
            if (context.Interactor is HexHeroModel hero)
            {
                return hero.Character == _value;
            }
            return false;
        }
    }
}
