﻿using UnityEngine;

namespace PK
{
    public class ActionCheckEntityEnabledNode : ActionDefaultNode, IConditionNode
    {
        [SerializeField] private bool _isSelf;
        [SerializeField] private ulong _entityId;
        [SerializeField] private bool _value;

        bool IConditionNode.Evaluate(IActionContext context)
        {
            HexEntityModel entity;
            if (_isSelf && context.Executor is HexGlobalTriggerModel trigger)
            {
                return trigger.Enabled;
            }
            else
            {
                if (_isSelf)
                {
                    entity = context.Executor as HexEntityModel;
                }
                else
                {
                    entity = context.Map.GetEntity(_entityId);
                }
                if (entity == null)
                {
                    Debug.LogError($"Entity is missing.");
                    return false;
                }
                return entity.Enabled == _value;
            }
        }
    }
}
