﻿using UnityEngine;

namespace PK
{
    public class ActionCheckVariableNode : ActionDefaultNode, IConditionNode
    {
        private enum ComparisonType
        {
            EqualTo,
            NotEqualTo,
            LessThan,
            MoreThan
        }

        [SerializeField] private ulong _id;
        [SerializeField] private string _name;
        [SerializeField] private VariableType _type;
        [SerializeField] private ComparisonType _comparison;
        [SerializeField] private bool _boolValue;
        [SerializeField] private int _intValue;

        public ulong Id { get { return _id; } set { _id = value; } }
        public string Name { get { return _name; } set { _name = value; } }
        public VariableType Type { get { return _type; } set { _type = value; } }

        bool IConditionNode.Evaluate(IActionContext context)
        {
            VariableType variableType = context.Map.GlobalVariables.GetVariableType(_id);
            if (_type != variableType) {
                Debug.LogError($"ActionCheckVariableNode: variable type mismatch!");
            }
            else if (_type == VariableType.Bool)
            {
                if (context.Map.GlobalVariables.GetBool(_id) == _boolValue)
                {
                    return true;
                }
                return false;
            }
            else if (_type == VariableType.Int)
            {
                int value = context.Map.GlobalVariables.GetInt(_id);
                switch (_comparison)
                {
                    case ComparisonType.EqualTo:
                        if (value == _intValue)
                        {
                            return true;
                        }
                        break;
                    case ComparisonType.NotEqualTo:
                        if (value != _intValue)
                        {
                            return true;
                        }
                        break;
                    case ComparisonType.MoreThan:
                        if (value > _intValue)
                        {
                            return true;
                        }
                        break;
                    case ComparisonType.LessThan:
                        if (value < _intValue)
                        {
                            return true;
                        }
                        break;
                }
            }
            return false;
        }
    }
}
