﻿using UnityEngine;

namespace PK
{
    public interface IFlowNode
    {
        void Execute(IActionContext context);
    }

    public interface ICommandFlowNode : IFlowNode
    {
    }

    public interface IConditionNode
    {
        bool Evaluate(IActionContext context);
    }

    public abstract class ActionDefaultNode : BaseNode
    {
        [SerializeField] protected string _inPortGuid;
        [SerializeField] protected string _outPortGuid;

        public string InPortGuid { get { return _inPortGuid; } set { _inPortGuid = value; } }
        public string OutPortGuid { get { return _outPortGuid; } set { _outPortGuid = value; } }
    }
}
