﻿using PK.Strategic;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using UnityEngine.UIElements;

namespace PK
{
    public class ActionOverrideTerrainNode : ActionDefaultNode, IFlowNode
    {
        [SerializeField] private ulong _entityId;

        [SerializeField] private bool _revertOverride = false;

        [SerializeField] private List<KeyValue<HexTerrain, HexTerrain>> _terrainToTerrain = new();


        void IFlowNode.Execute(IActionContext context)
        {
            HexEntityModel entity = context.Map.GetEntity(_entityId);
            if (entity != null && entity is HexMapZoneModel mapZone)
            {
                if (_revertOverride)
                {
                    for (int i = 0; i < mapZone.Points.Count; i++)
                    {
                        Vector2Int position = mapZone.GetPosition(i);
                        context.Map.ResetTileOverride(position);
                    }
                }
                else
                {
                    var terrainDict = _terrainToTerrain.ToDictionary(kvp => kvp.Key, kvp => kvp.Value);
                    for (int i = 0; i < mapZone.Points.Count; i++)
                    {
                        Vector2Int position = mapZone.GetPosition(i);

                        ulong currentTerrainTile = context.Map.GetTerrainTile(position);
                        HexTile currentHexTile = HexDatabase.Instance.GetTile(currentTerrainTile);
                        if (currentHexTile == null || !terrainDict.ContainsKey(currentHexTile.Terrain))
                        {
                            continue;
                        }
                        HexTile targetHexTile = HexTerrainOverrides.Instance.GetOverrideTile(currentHexTile, terrainDict[currentHexTile.Terrain]);
                        if (targetHexTile.Equals(currentHexTile))
                        {
                            Debug.LogError("No replacement rules for " + currentHexTile.name + ":" + currentHexTile.Terrain.name + " -> " + terrainDict[currentHexTile.Terrain]);
                        }
                        context.Map.SetTileOverride(position, targetHexTile.Uid);
                    }
                }
                context.EventManager.Get<MapEvents>().CallOnHexTerrainChanged();
            }
            else
            {
                Debug.LogWarning("Entity is null or not map zone.");
            }
            context.Graph.MoveToNextNode(_outPortGuid);
        }
    }
}
