﻿using UnityEditor.Experimental.GraphView;
using UnityEngine.UIElements;

namespace PK
{
    public class ActionGraphBlackboardProvider
    {
        private ActionGraphView _graphView;
        private Blackboard _blackboard;

        private BlackboardSection _variableSection;

        public Blackboard Blackboard { get { return _blackboard; } }

        public ActionGraphBlackboardProvider(ActionGraphView graphView)
        {
            _graphView = graphView;
            _blackboard = new Blackboard() { scrollable = true, title = "Properties", editTextRequested = EditTextRequested, addItemRequested = AddItemRequested, moveItemRequested = MoveItemRequested };

            _variableSection = new BlackboardSection() { title = "Variables" };
            _blackboard.Add(_variableSection);
        }

        private void EditTextRequested(Blackboard blackboard, VisualElement visualElement, string newText)
        {

        }

        private void AddItemRequested(Blackboard blackboard)
        {

        }

        private void MoveItemRequested(Blackboard blackboard, int newIndex, VisualElement visualElement)
        {

        }
    }
}
