﻿using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionAddCreatureSquadsNode), "Add Creature Squads")]
    public class ActionAddCreatureSquadsEditorNode : ActionDefaultEditorNode
    {
        public ActionAddCreatureSquadsEditorNode(SerializedProperty property) : base(property)
        {
            title = "Add Creature Squads";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty creaturesProperty = property.FindPropertyRelative("_creatures");
            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                EditorGUILayout.PropertyField(creaturesProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
