﻿using UnityEditor;
using UnityEditor.Rendering;
using UnityEngine.UIElements;
using static PK.HexVariablesModel;

namespace PK
{
    [EditorNode(typeof(ActionModifyVariableNode), "Variables/Modify")]
    public class ActionModifyVariableEditorNode : ActionDefaultEditorNode
    {
        public ActionModifyVariableEditorNode(SerializedProperty property) : base(property)
        {
            title = "Modify Variable";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty idProperty = property.FindPropertyRelative("_id");
            SerializedProperty typeProperty = property.FindPropertyRelative("_type");
            SerializedProperty operationProperty = property.FindPropertyRelative("_operation");
            SerializedProperty boolValueProperty = property.FindPropertyRelative("_boolValue");
            SerializedProperty intValueProperty = property.FindPropertyRelative("_intValue");

            VariableButton variableButton = new VariableButton(this, idProperty);
            extensionContainer.Add(variableButton);

            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                Variable variable = MapDataHelper.GetVariable(idProperty.ulongValue);
                if (variable != null)
                {
                    if (variable.Type == VariableType.Bool)
                    {
                        typeProperty.SetEnumValue(VariableType.Bool);
                        PropertyHelper.PropertyField(boolValueProperty);
                    }
                    else
                    {
                        typeProperty.SetEnumValue(VariableType.Int);
                        PropertyHelper.PropertyField(operationProperty);
                        PropertyHelper.PropertyField(intValueProperty);
                    }
                }
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
