using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionSetWeatherNode), "Weather/Set Weather")]
    public class ActionSetWeatherEditorNode : ActionDefaultEditorNode
    {
        public ActionSetWeatherEditorNode(SerializedProperty property) : base(property)
        {
            title = "Set Weather";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty weatherProperty = property.FindPropertyRelative("weather");
            SerializedProperty severityProperty = property.FindPropertyRelative("severity");
            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                PropertyHelper.PropertyField(weatherProperty);
                PropertyHelper.PropertyField(severityProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
