﻿using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionCreatureSquadsSurrenderNode), "Tactical/Creature Squads Surrender")]
    public class ActionCreatureSquadsSurrenderEditorNode : ActionDefaultEditorNode
    {
        public ActionCreatureSquadsSurrenderEditorNode(SerializedProperty property) : base(property)
        {
            title = "Add Creature Squads";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty playerProperty = property.FindPropertyRelative("_player");
            SerializedProperty creaturesProperty = property.FindPropertyRelative("_creatures");
            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                EditorGUILayout.PropertyField(playerProperty);
                EditorGUILayout.PropertyField(creaturesProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
