﻿using UnityEngine;

namespace PK
{
    public enum EntityType
    {
        Unknown,
        Entity,
        Object,
        Creature,
        CreatureSquad,
        Hero,
        ProximityTrigger,
        SpawnPoint,
        MapZone,
    }

    public interface IEntityModelForView
    {
        public ulong Uid { get; }
        public ulong Id { get; }
        public Vector2Int Position { get; }
        public EntityType Type { get; }
        public bool Enabled { get; }
    }

    [System.Serializable]
    public class HexEntityModel : IEntityModelForView
    {
        [SerializeField, HideInInspector] protected ulong _uid;
        [SerializeField, HideInInspector] protected ulong _id;
        [SerializeField, HideInInspector] protected Vector2Int _position;
        [SerializeField] protected string _name;
        [SerializeField] protected bool _enabled = true;

        public ulong Uid { get { return _uid; } }
        public ulong Id { get { return _id; } internal set { _id = value; } } // Local map id
        public Vector2Int Position { get { return _position; } set { _position = value; } }
        public virtual EntityType Type { get { return EntityType.Entity; } }
        public string Name { get { return _name; } set { _name = value; } }
        public bool Enabled { get { return _enabled; } set { _enabled = value; } }
    }
}
