﻿using UnityEngine;

namespace PK
{
    [System.Serializable]
    public struct NodeConnection
    {
        [SerializeField] private NodeConnectionPort _inputPort;
        [SerializeField] private NodeConnectionPort _outputPort;

        public NodeConnectionPort InputPort { get { return _inputPort; } }
        public NodeConnectionPort OutputPort { get { return _outputPort; } }

        public NodeConnection(NodeConnectionPort inputPort, NodeConnectionPort outputPort)
        {
            _inputPort = inputPort;
            _outputPort = outputPort;
        }

        public NodeConnection(string inputNodeGuid, string inputPortGuid, string outputNodeGuid, string outputPortGuid)
        {
            _inputPort = new NodeConnectionPort(inputNodeGuid, inputPortGuid);
            _outputPort = new NodeConnectionPort(outputNodeGuid, outputPortGuid);
        }
    }

    [System.Serializable]
    public struct NodeConnectionPort
    {
        [SerializeField] private string _nodeGuid;
        [SerializeField] private string _portGuid;

        public string NodeGuid { get { return _nodeGuid; } }
        public string PortGuid { get { return _portGuid; } }

        public NodeConnectionPort(string nodeGuid, string portGuid)
        {
            _nodeGuid = nodeGuid;
            _portGuid = portGuid;
        }
    }
}
