﻿using UnityEngine;

namespace PK
{
    public static class CameraHelper
    {
        // https://discussions.unity.com/t/how-to-check-if-a-point-is-seeable-by-a-camera/5557/6
        public static bool IsVisible(Vector3 worldPosition, Camera camera)
        {
            Vector3 viewportPosition = camera.WorldToViewportPoint(worldPosition);
            bool inCameraFrustum = viewportPosition.x > 0 && viewportPosition.x < 1 && viewportPosition.y > 0 && viewportPosition.y < 1;
            bool inFrontOfCamera = viewportPosition.z > 0;
            return inCameraFrustum && inFrontOfCamera;
        }
    }
}
