﻿using System.Linq;
using UnityEngine;
using UnityEngine.Rendering;

namespace PK
{
    public static class GraphicsExt
    {
        private static Material _material;
        private static Mesh _mesh;
        private static Color[] _colors;

        public static void DrawSprite(Sprite sprite, Vector3 position, Color color)
        {
            if (sprite == null)
            {
                return;
            }
            PrepareMesh(sprite, color);
            Graphics.DrawMesh(_mesh, Matrix4x4.TRS(position, Quaternion.identity, Vector3.one), _material, 0, Camera.current);
        }

        public static void DrawSprite(this CommandBuffer cmd, Sprite sprite, Vector3 position, Color color)
        {
            if (sprite == null)
            {
                return;
            }
            PrepareMesh(sprite, color);
            cmd.DrawMesh(_mesh, Matrix4x4.TRS(position, Quaternion.identity, Vector3.one), _material, 0);
        }

        private static void PrepareMesh(Sprite sprite, Color color)
        {
            if (_mesh == null)
            {
                _mesh = new Mesh();
                _mesh.MarkDynamic();
            }
            else
            {
                _mesh.Clear();
            }

            if (_material == null)
            {
                Shader shader = Shader.Find("Universal Render Pipeline/2D/Sprite-Unlit-Default");
                _material = new Material(shader);
                _material.renderQueue = (int)RenderQueue.Transparent + 1;
            }
            _material.SetTexture("_MainTex", sprite.texture);

            Vector2[] vertices = sprite.vertices;
            if (_colors == null || vertices.Length > _colors.Length)
            {
                _colors = new Color[vertices.Length];
            }
            System.Array.Fill(_colors, color, 0, vertices.Length);

            _mesh.SetVertices(vertices.Select((v) => new Vector3(v.x, v.y)).ToArray());
            _mesh.SetUVs(0, sprite.uv);
            _mesh.SetColors(_colors, 0, vertices.Length);
            _mesh.SetTriangles(sprite.triangles.Select((t) => (int)t).ToArray(), 0);
            _mesh.UploadMeshData(false);
        }
    }
}
