﻿using System;
using UnityEngine.UIElements;

namespace PK
{
    public class LabelButton : VisualElement
    {
        private Button _button;

        public Button Button { get { return _button; } }

        public LabelButton(string name, string text, Action onClick)
        {
            style.alignItems = Align.Center;
            style.flexDirection = FlexDirection.Row;
            Label label = new Label(name);
            Add(label);

            _button = new Button();
            _button.clicked += onClick;
            _button.style.flexGrow = 1;
            _button.text = text;
            Add(_button);
        }
    }
}
