﻿using System.Collections.Generic;
using UnityEngine;

namespace PK
{
    [DefaultExecutionOrder(-100)]
    public class ImmediateSpriteRenderer : MonoBehaviour
    {
        private static ImmediateSpriteRenderer _instance;

        private List<SpriteRenderer> _activeRenderers = new();

        public static void DrawSprite(Vector3 worldPosition, Sprite sprite, int sortingOrder)
        {
            DrawSprite(worldPosition, sprite, sortingOrder, Color.white);
        }

        public static void DrawSprite(Vector3 worldPosition, Sprite sprite, int sortingOrder, Color color)
        {
            if (_instance == null)
            {
                GameObject gameObject = new GameObject();
                gameObject.hideFlags = HideFlags.HideInHierarchy;
                _instance = gameObject.AddComponent<ImmediateSpriteRenderer>();
            }

            SpriteRenderer renderer = SpriteRendererPool.Get();
            renderer.transform.position = worldPosition;
            renderer.sprite = sprite;
            renderer.sortingOrder = sortingOrder;
            renderer.color = color;
            _instance._activeRenderers.Add(renderer);
        }

        private void Update()
        {
            if (_activeRenderers.Count > 0)
            {
                foreach (SpriteRenderer renderer in _activeRenderers)
                {
                    renderer.color = Color.white;
                    SpriteRendererPool.Release(renderer);
                }
                _activeRenderers.Clear();
            }
        }
    }
}
