﻿using System.Collections.Generic;
using UnityEngine;

namespace PK
{
    // https://discussions.unity.com/t/solved-how-to-serialize-dictionary-with-unity-serialization-system/71474/4

    [System.Serializable]
    public class SerializableDictionary<TKey, TValue> : Dictionary<TKey, TValue>, ISerializationCallbackReceiver
    {
        [SerializeField] private List<TKey> _keys = new List<TKey>();
        [SerializeField] private List<TValue> _values = new List<TValue>();

        void ISerializationCallbackReceiver.OnAfterDeserialize()
        {
            _keys.Clear();
            _values.Clear();
            foreach (KeyValuePair<TKey, TValue> pair in this)
            {
                _keys.Add(pair.Key);
                _values.Add(pair.Value);
            }
        }

        void ISerializationCallbackReceiver.OnBeforeSerialize()
        {
            Clear();
            if (_keys.Count != _values.Count)
            {
                throw new System.Exception(string.Format("there are {0} keys and {1} values after deserialization. Make sure that both key and value types are serializable."));
            }
            for (int i = 0; i < _keys.Count; i++)
            {
                Add(_keys[i], _values[i]);
            }
        }
    }
}
