using UnityEditor;
using UnityEngine;

namespace PK
{
    public class HexMapAssetPostprocessor : AssetPostprocessor
    {
        static void OnPostprocessAllAssets(string[] importedAssets, string[] deletedAssets, string[] movedAssets, string[] movedFromAssetPaths, bool didDomainReload)
        {
            if (importedAssets.Length > 1)
            {
                foreach (string path in importedAssets)
                {
                    if (path.EndsWith(".spriteatlasv2"))
                    {
                        AssetDatabase.ImportAsset(path);
                    }
                }
            }
            // Delay to avoid fast database validating
            EditorApplication.delayCall += DelayedUpdate;
        }

        private static void DelayedUpdate()
        {
            HexDatabase.Invalidate();
            foreach (HexMapWritableView view in Object.FindObjectsOfType<HexMapWritableView>())
            {
                view.UpdateAll();
            }
        }
    }
}
