﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    [CustomEntityEditor(typeof(HexMapZoneModel))]
    public class MapZoneEntityEditor : EntityEditor
    {
        private static Color MASK_COLOR = new Color(0, 1, 0, 0.3f);

        private bool _isEditing = false;

        public override void OnInspectorPanel()
        {
            base.OnInspectorPanel();
            _isEditing = GUILayout.Toggle(_isEditing, "Edit", GUI.skin.button);
        }

        public override void OnMouseDown()
        {
            if (_isEditing)
            {
                HexMapZoneModel area = Target as HexMapZoneModel;
                Vector2Int axialPoint = HexHelper.OddToAxial(HoveredTile) - HexHelper.OddToAxial(area.Position);
                if (Event.current.button == 0)
                {
                    if (!area.Points.Contains(axialPoint))
                    {
                        area.Points.Add(axialPoint);
                        SerializedProperty.serializedObject.Update();
                    }
                    Event.current.Use();
                }
                if (Event.current.button == 1)
                {
                    if (area.Points.Contains(axialPoint))
                    {
                        area.Points.Remove(axialPoint);
                        SerializedProperty.serializedObject.Update();
                    }
                    Event.current.Use();
                }
            }
        }

        public override void OnDrawSelection()
        {
            HexMapZoneModel area = Target as HexMapZoneModel;
            Vector2Int axialPosition = HexHelper.OddToAxial(area.Position);
            using (new Handles.DrawingScope(MASK_COLOR))
            {
                foreach (Vector2Int point in area.Points)
                {
                    Handles.DrawAAConvexPolygon(HexHelper.GetTileCorners(HexHelper.GetTilePosition(HexHelper.AxialToOdd(axialPosition + point))));
                }
            }
        }
    }
}
