﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    [CustomEntityEditor(typeof(HexObjectModel))]
    public class ObjectEntityEditor : EntityEditor
    {
        private static int OBJECT_ENTITY_EDITOR_HASH = "ObjectEntityEditor".GetHashCode();

        public override void OnInspectorPanel()
        {
            base.OnInspectorPanel();

            int controlId = GUIUtility.GetControlID(OBJECT_ENTITY_EDITOR_HASH, FocusType.Keyboard);
            if (GUILayout.Button("Replace"))
            {
                EditorGUIUtility.ShowObjectPicker<HexObject>(null, false, "", controlId);
            }
            if (Event.current.commandName == "ObjectSelectorUpdated")
            {
                if (EditorGUIUtility.GetObjectPickerControlID() == controlId)
                {
                    if (EditorGUIUtility.GetObjectPickerObject() is HexObject @object)
                    {
                        Editor.RecordUndo();
                        SerializedProperty.FindPropertyRelative("_uid").ulongValue = @object.Uid;
                        SerializedProperty.serializedObject.ApplyModifiedProperties();
                        View.Clear();
                        View.UpdateAll();
                        Editor.Repaint();
                    }
                }
            }
        }
    }
}
